"""
https://tk-tools.readthedocs.io/en/latest/widget_groups.html
https://www.python-course.eu/tkinter_canvas.php
https://www.python-kurs.eu/tkinter_labels.php
https://stackoverflow.com/questions/2400262/how-to-create-a-timer-using-tkinter
https://raspberrypi.stackexchange.com/questions/91517/tkinter-push-button-with-virtual-buttons
"""
from tkinter import *
import time

state_timer = 0

state_qx0_0 = 0
state_qx0_1 = 0
state_qx0_2 = 0
state_qx0_3 = 0

state_ix0_0 = 0
state_ix0_1 = 0
state_ix0_2 = 0
state_ix0_3 = 0

adc_value = 0

slider_value = 0;

enable = 1

counter = 0

_callback_id = None

# Die folgende Funktion soll ausgeführt werden, wenn
# der Benutzer den Button anklickt

def close_window():
    mainwindow.destroy()

def button_action_q0():
    global state_qx0_0
    #global _callback_id
    if (state_qx0_0 == 0):
        state_qx0_0 = 1
        state_q0_0_label.config(text="ON")
        change_button_qx0_0.config(text="QX0_0 OFF")
        label_input_ix00.config(bg='red')


    else:
        state_qx0_0 = 0
        state_q0_0_label.config(text="OFF")
        change_button_qx0_0.config(text="QX0_0 ON ")
        label_input_ix00.config(bg='green')


def button_action_q1():
    global state_qx0_1
    if (state_qx0_1 == 0):
        state_qx0_1 = 1
        state_q0_1_label.config(text="ON")
        change_button_qx0_1.config(text="QX0_1 OFF")
    else:
        state_qx0_1 = 0
        state_q0_1_label.config(text="OFF")
        change_button_qx0_1.config(text="QX0_1 ON ")
        #enable = 0
def button_action_q2():
    global state_qx0_2
    if (state_qx0_2 == 0):
        state_qx0_2 = 1
        state_q0_2_label.config(text="ON")
        change_button_qx0_2.config(text="QX0_2 OFF")
    else:
        state_qx0_2 = 0
        state_q0_2_label.config(text="OFF")
        change_button_qx0_2.config(text="QX0_2 ON ")

def button_action_q3():
    global state_qx0_3
    if (state_qx0_3 == 0):
        state_qx0_3 = 1
        state_q0_3_label.config(text="ON")
        change_button_qx0_3.config(text="QX0_3 OFF")
    else:
        state_qx0_3 = 0
        state_q0_3_label.config(text="OFF")
        change_button_qx0_3.config(text="QX0_3 ON ")

def button_start_stop():
    global enable
    global state_timer
    if (state_timer == 0):
        state_timer = 1
        stop_clock()
        start_stop_button.config(text="Start")
    else:
        state_timer = 0
        enable = 1
        start_clock()
        start_stop_button.config(text="Stop")


def slider_action(val):
    u = slider.get()
    info_label.config(text=u)
    #now = time.strftime("%H:%M:%S")
    #time_label.config(text=now)
    

def start_clock():
    global _callback_id
    global counter
    #now = time.strftime("%H:%M:%S")
    counter = counter + 1
    #time_label.configure(text=now)
    time_label.configure(text=counter)
    if enable==1:
         _callback_id = mainwindow.after(100, start_clock)
    else:
         mainwindow.after_cancel(_callback_id)

    
def stop_clock():
    global enable
    enable = 0
    

# create mainwindow
mainwindow = Tk()
# mainwindow title
mainwindow.title("Modbus TCP WIFI TestSoftware 0.0")

# size of mainwindow
mainwindow.geometry("480x320")
mainwindow.resizable(0, 0)


# Labels and Buttons
change_button_qx0_0 = Button(mainwindow, text="QX0_0 ON", command=button_action_q0)
change_button_qx0_1 = Button(mainwindow, text="QX0_1 ON", command=button_action_q1)
change_button_qx0_2 = Button(mainwindow, text="QX0_2 ON", command=button_action_q2)
change_button_qx0_3 = Button(mainwindow, text="QX0_3 ON", command=button_action_q3)

start_stop_button = Button(mainwindow, text="Stop", command=button_start_stop)

state_q0_0_label = Label(mainwindow, text="OFF")
state_q0_1_label = Label(mainwindow, text="OFF")
state_q0_2_label = Label(mainwindow, text="OFF")
state_q0_3_label = Label(mainwindow, text="OFF")

label_info_ix00 = Label(mainwindow, text="IX0.0")
label_input_ix00 = Label(mainwindow, text="      ", bg='green')

label_info_ix01 = Label(mainwindow, text="IX0.1")
label_input_ix01 = Label(mainwindow, text="      ", bg='green')

label_info_ix02 = Label(mainwindow, text="IX0.2")
label_input_ix02 = Label(mainwindow, text="      ", bg='green')

label_info_ix03 = Label(mainwindow, text="IX0.3")
label_input_ix03 = Label(mainwindow, text="      ", bg='green')


label_input_adc = Label(mainwindow, text="ADC..")


exit_button = Button(mainwindow, text="Beenden", command=close_window)

slider = Scale(from_=0, to=10, resolution=0.01, orient=HORIZONTAL, command=slider_action )

info_label = Label(mainwindow, text="DAC Value..")

time_label = Label(mainwindow)


state_q0_0_label.place(x = 20, y = 40, width=80, height=30)
change_button_qx0_0.place(x = 100, y = 40, width=80, height=30)

state_q0_1_label.place(x = 20, y = 80, width=80, height=30)
change_button_qx0_1.place(x = 100, y = 80, width=80, height=30)

state_q0_2_label.place(x = 20, y = 120, width=80, height=30)
change_button_qx0_2.place(x = 100, y = 120, width=80, height=30)

state_q0_3_label.place(x = 20, y = 160, width=80, height=30)
change_button_qx0_3.place(x = 100, y = 160, width=80, height=30)

exit_button.place(x = 340, y = 280, width=80, height=30)
start_stop_button.place(x = 20, y = 280, width=60, height=30)


label_info_ix00.place(x = 260, y = 40, width=80, height=30)
label_input_ix00.place(x = 340, y = 40, width=80, height=30)

label_info_ix01.place(x = 260, y = 80, width=80, height=30)
label_input_ix01.place(x = 340, y = 80, width=80, height=30)

label_info_ix02.place(x = 260, y = 120, width=80, height=30)
label_input_ix02.place(x = 340, y = 120, width=80, height=30)

label_info_ix03.place(x = 260, y = 160, width=80, height=30)
label_input_ix03.place(x = 340, y = 160, width=80, height=30)


info_label.place(x = 200, y = 240, width=80, height=30)

label_input_adc.place(x = 200, y = 280, width=80, height=30)

time_label.place(x = 80, y = 280, width=80, height=30)




slider.place(x = 30, y = 190, width=420, height=40)

start_clock()

# In der Ereignisschleife auf Eingabe des Benutzers warten.
mainwindow.mainloop()
